@extends('admin.layouts.app')
@section('panel')
    <div class="row mb-none-30">
        <div class="col-lg-12 col-md-12 mb-30">
            <div class="card">
                <div class="card-body">
                    <form method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-xl-3 col-sm-6">
                                <div class="form-group ">
                                    <label> @lang('Site Title')</label>
                                    <input class="form-control" type="text" name="site_name" required value="{{ gs('site_name') }}">
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="form-group ">
                                    <label>@lang('Currency')</label>
                                    <input class="form-control" type="text" name="cur_text" required value="{{ gs('cur_text') }}">
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="form-group ">
                                    <label>@lang('Currency Symbol')</label>
                                    <input class="form-control" type="text" name="cur_sym" required value="{{ gs('cur_sym') }}">
                                </div>
                            </div>
                            <div class="form-group col-xl-3 col-sm-6">
                                <label class="required"> @lang('Timezone')</label>
                                <select class="select2 form-control" name="timezone">
                                    @foreach ($timezones as $key => $timezone)
                                        <option value="{{ @$key }}" @selected(@$key == $currentTimezone)>{{ __($timezone) }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-xl-3 col-sm-6">
                                <label>@lang('Balance Transfer Fixed Charge')</label>
                                <div class="input-group">
                                    <input class="form-control bal-charge" type="text" name="f_charge" required value="{{ getAmount(gs('f_charge')) }}" @if (!gs('b_transfer')) readonly @endif>
                                    <div class="input-group-text">{{ gs('cur_text') }}</div>
                                </div>
                            </div>
                            <div class="form-group col-xl-3 col-sm-6">
                                <label>@lang('Balance Transfer Percent Charge')</label>
                                <div class="input-group">
                                    <input class="form-control bal-charge" type="text" name="p_charge" required value="{{ getAmount(gs('p_charge')) }}" @if (!gs('b_transfer')) readonly @endif>
                                    <div class="input-group-text">%</div>
                                </div>
                            </div>
                            
                            <div class="form-group col-xl-3 col-sm-6">
                                <label> @lang('Record to Display Per page')</label>
                                <select class="select2 form-control" name="paginate_number" data-minimum-results-for-search="-1">
                                    <option value="20" @selected(gs('paginate_number') == 20)>@lang('20 items per page')</option>
                                    <option value="50" @selected(gs('paginate_number') == 50)>@lang('50 items per page')</option>
                                    <option value="100" @selected(gs('paginate_number') == 100)>@lang('100 items per page')</option>
                                </select>
                            </div>

                            
                            
                           
                           <div class="form-group col-xl-3 col-sm-6">
                                <label>@lang('BTC Rate')</label>
                                <div class="input-group">
                                    <input class="form-control bal-charge" type="text" name="btc_rate" required value="{{ getAmount(gs('btc_rate')) }}">
                                    <div class="input-group-text">{{ gs('cur_text') }}</div>
                                </div>
                            </div>
                            
                             <div class="form-group col-xl-3 col-sm-6">
                                <label>@lang('ETH Rate')</label>
                                <div class="input-group">
                                    <input class="form-control bal-charge" type="text" name="eth_rate" required value="{{ getAmount(gs('eth_rate')) }}">
                                    <div class="input-group-text">{{ gs('cur_text') }}</div>
                                </div>
                            </div>
                            
                            <div class="form-group col-xl-3 col-sm-6">
                                <label>@lang('Tron Rate')</label>
                                <div class="input-group">
                                    <input class="form-control bal-charge" type="text" name="tron_rate" required value="{{ getAmount(gs('tron_rate')) }}">
                                    <div class="input-group-text">{{ gs('cur_text') }}</div>
                                </div>
                            </div>
                            
                             <div class="form-group col-xl-3 col-sm-6">
                                <label>@lang('BNB Rate')</label>
                                <div class="input-group">
                                    <input class="form-control bal-charge" type="text" name="bnb_rate" required value="{{ getAmount(gs('bnb_rate')) }}">
                                    <div class="input-group-text">{{ gs('cur_text') }}</div>
                                </div>
                            </div>
                            
                            <div class="form-group col-xl-3 col-sm-6">
                                <label>@lang('XRP Rate')</label>
                                <div class="input-group">
                                    <input class="form-control bal-charge" type="text" name="xrp_rate" required value="{{ getAmount(gs('xrp_rate')) }}">
                                    <div class="input-group-text">{{ gs('cur_text') }}</div>
                                </div>
                            </div>
                            
                            <div class="form-group col-xl-3 col-sm-6">
                                <label>@lang('XLM Rate')</label>
                                <div class="input-group">
                                    <input class="form-control bal-charge" type="text" name="xlm_rate" required value="{{ getAmount(gs('xlm_rate')) }}">
                                    <div class="input-group-text">{{ gs('cur_text') }}</div>
                                </div>
                            </div>
                            
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('script-lib')
    <script src="{{ asset('assets/admin/js/spectrum.js') }}"></script>
@endpush

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/spectrum.css') }}">
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";


            $('.colorPicker').spectrum({
                color: $(this).data('color'),
                change: function(color) {
                    $(this).parent().siblings('.colorCode').val(color.toHexString().replace(/^#?/, ''));
                }
            });

            $('.colorCode').on('input', function() {
                var clr = $(this).val();
                $(this).parents('.input-group').find('.colorPicker').spectrum({
                    color: clr,
                });
            });
        })(jQuery);
    </script>
@endpush
